#version 120
#extension GL_EXT_gpu_shader4 : enable

#if defined IS_IRIS && defined DISTANT_HORIZONS


//Horizontal bilateral blur for volumetric fog + Forward rendered objects + Draw volumetric fog


#define BORDER_FOG 3 //[0 1 2 3 4 5 6 7 8 9 10] // amount of render distance in tenths to use for border fog . it's a fade out effect


flat varying vec3 zMults;
uniform sampler2D depthtex0;
uniform sampler2D colortex7;
uniform sampler2D colortex3;
uniform sampler2D colortex2;
uniform sampler2D colortex0;
uniform sampler2D colortex15;//sky background
uniform sampler2D noisetex;

uniform float frameTimeCounter;
uniform int frameCounter;
uniform float far;
uniform float near;
uniform int isEyeInWater;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferProjectionInverse;
uniform vec2 texelSize;
//uniform vec3 waterfogcolor;
uniform vec3 cameraPosition;
#include "lib/waterOptions.glsl"
#include "/lib/res_params.glsl"
#include "settings_1.glsl"
#define BORDER_FOG_CLOUDS 2 //[0 1 2 3 4 5 6 7 8 9 10] // amount of the fog distance in tenths to have clouds in . 0 or too low will create pop-in! 10 will be very smooth fade in with clouds in it . 10 was the old default

#define clamp01(x) clamp(x, 0.0, 1.0)
#define fsign(x) (clamp01(x * 1e35) * 2.0 - 1.0)
float ld(float depth) {
    return 1.0 / (zMults.y - depth * zMults.z);		// (-depth * (far - near)) = (2.0 * near)/ld - far - near
}
#define diagonal3(m) vec3((m)[0].x, (m)[1].y, m[2].z)
#define  projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)
vec3 toScreenSpace(vec3 p) {
	vec4 iProjDiag = vec4(gbufferProjectionInverse[0].x, gbufferProjectionInverse[1].y, gbufferProjectionInverse[2].zw);
    vec3 p3 = p * 2. - 1.;
    vec4 fragposition = iProjDiag * p3.xyzz + gbufferProjectionInverse[3];
    return fragposition.xyz / fragposition.w;
}
vec4 BilateralUpscale(sampler2D tex, sampler2D depth,vec2 coord,float frDepth){
  coord = coord;
  vec4 vl = vec4(0.0);
  float sum = 0.0;
  mat3x3 weights;
  const ivec2 scaling = ivec2(1.0/VL_RENDER_RESOLUTION);
  ivec2 posD = ivec2(coord*VL_RENDER_RESOLUTION)*scaling;
  ivec2 posVl = ivec2(coord*VL_RENDER_RESOLUTION);
  float dz = zMults.x;
  ivec2 pos = (ivec2(gl_FragCoord.xy+frameCounter) % 2 )*2;
	//pos = ivec2(1,-1);

  ivec2 tcDepth =  posD + ivec2(-2,-2) * scaling + pos * scaling;
  float dsample = ld(texelFetch2D(depth,tcDepth,0).r);
  float w = abs(dsample-frDepth) < dz ? 1.0 : 1e-5;
  vl += texelFetch2D(tex,posVl+ivec2(-2)+pos,0)*w;
  sum += w;

	tcDepth =  posD + ivec2(-2,0) * scaling + pos * scaling;
  dsample = ld(texelFetch2D(depth,tcDepth,0).r);
  w = abs(dsample-frDepth) < dz ? 1.0 : 1e-5;
  vl += texelFetch2D(tex,posVl+ivec2(-2,0)+pos,0)*w;
  sum += w;

	tcDepth =  posD + ivec2(0) + pos * scaling;
  dsample = ld(texelFetch2D(depth,tcDepth,0).r);
  w = abs(dsample-frDepth) < dz ? 1.0 : 1e-5;
  vl += texelFetch2D(tex,posVl+ivec2(0)+pos,0)*w;
  sum += w;

	tcDepth =  posD + ivec2(0,-2) * scaling + pos * scaling;
  dsample = ld(texelFetch2D(depth,tcDepth,0).r);
  w = abs(dsample-frDepth) < dz ? 1.0 : 1e-5;
  vl += texelFetch2D(tex,posVl+ivec2(0,-2)+pos,0)*w;
  sum += w;

  return vl/sum;
}
float getWaterHeightmap(vec2 posxz, float iswater) {
	vec2 pos = posxz;
  float moving = clamp(iswater*2.-1.0,0.0,1.0);
	vec2 movement = vec2(-0.005*frameTimeCounter*moving,0.0);
	float caustic = 0.0;
	float weightSum = 0.0;
	float radiance =  2.39996;
	mat2 rotationMatrix  = mat2(vec2(cos(radiance),  -sin(radiance)),  vec2(sin(radiance),  cos(radiance)));
	for (int i = 1; i < 3; i++){
		vec2 displ = texture2D(noisetex, pos/32.0/1.74/1.74 + movement).bb*2.0-1.0;
    float wave = texture2D(noisetex, (pos*vec2(3., 1.0)/128. + movement + displ/128.0)*exp(i*1.0)).b;
		caustic += wave*exp(-i*1.0);
		weightSum += exp(-i*1.0);
		pos = rotationMatrix * pos;
	}
	return caustic / weightSum;
}

uniform sampler2D depthtex1;
	#ifdef DISTANT_HORIZONS

uniform float dhNearPlane;
uniform float dhFarPlane;
float linearize_depth_dh(in float d)
{
#if CPF_NEAR_FAR__WORKAROUND == 1
float far = RENDER_DISTANCE_CPF;
float near = 0.05;
#endif
    // from gl_FragCoord.z to world measurements
    return 2.0 * dhNearPlane  * dhFarPlane / (dhFarPlane + dhNearPlane - (2.0 * d - 1.0) * (dhFarPlane - dhNearPlane));

}
#endif
float linearize_depth_cpf(in float d)
{
#if CPF_NEAR_FAR__WORKAROUND == 1
float far = RENDER_DISTANCE_CPF;
float near = 0.05;
#endif
    // from gl_FragCoord.z to world measurements
    return 2.0 * near  * far / (far + near - (2.0 * d - 1.0) * (far - near));

}


uniform sampler2D dhdepthtex1;
void main() {
  vec2 texcoord = gl_FragCoord.xy*texelSize;
  /* DRAWBUFFERS:73 */
  //3x3 bilateral upscale from half resolution
  float z = texture2D(depthtex0,texcoord).x;
  float frDepth = ld(z);
  vec4 vl = BilateralUpscale(colortex0,depthtex0,gl_FragCoord.xy,frDepth);



  vec4 transparencies = texture2D(colortex2,texcoord);
  vec4 trpData = texture2D(colortex7,texcoord);
  bool iswater = trpData.a > 0.99 ;
  vec2 refractedCoord = texcoord;

  if (iswater)
{
    vec3 fragpos = toScreenSpace(vec3(texcoord-vec2(0.0)*texelSize*0.5,z));
  	vec3 np3 = mat3(gbufferModelViewInverse) * fragpos + gbufferModelViewInverse[3].xyz + cameraPosition;
    float norm = getWaterHeightmap(np3.xz+np3.y, 1.0)-0.5;
    float displ = norm/(length(fragpos)/far)/2000. * (1.0 + isEyeInWater*2.0);
    refractedCoord += displ*RENDER_SCALE;

    if (texture2D(colortex7,refractedCoord).a < 0.99)
      refractedCoord = texcoord;

  }
  vec3 color = texture2D(colortex3,refractedCoord).rgb;

  

  
  	
  
  if (frDepth > 2.5/far || transparencies.a < 0.99)  // Discount fix for transparencies through hand
    color = color*(1.0-transparencies.a)+transparencies.rgb*10.;

  float dirtAmount = Dirt_Amount;
	vec3 waterEpsilon = vec3(Water_Absorb_R, Water_Absorb_G, Water_Absorb_B);
	vec3 dirtEpsilon = vec3(Dirt_Absorb_R, Dirt_Absorb_G, Dirt_Absorb_B);
	vec3 totEpsilon = dirtEpsilon*dirtAmount + waterEpsilon;

 
//if (iswater)
{
#if BORDER_FOG == 0
				#else
				
				#define DH_FOG .6 //[0. .1 .2 .3 .4 .5 .6 .7 .75 .77 .8 .82 .85 .9]
				
				#if defined IS_IRIS && defined DISTANT_HORIZONS
					float BORDER_FOG2 = 10.;//BORDER_FOG* 10./3./
					 float border_fog= (clamp((  	max(-texture2D(colortex15,texcoord.xy).w,
					
				
					  min(
					  max(0.,linearize_depth_cpf(texture2D(depthtex1,texcoord).r)),
					  
					 1111.
					 )
					 
					 )   -far*(1.-BORDER_FOG*.1))/(dhFarPlane*(1.-DH_FOG)),0.,1.));
	
		
		border_fog = pow(border_fog,1. - DH_FOG);
				 #else
		float border_fog  = textureLod(depthtex0,texcoord.xy,0).x;
				// from gl_FragCoord.z to world measurements
				border_fog = 2.0 * near  * far / (far + near - (2.0 * border_fog - 1.0) * (far - near));
				
				border_fog=clamp(2*border_fog/far,0.0,2.0);
				float curve = distance(texcoord.xy-.5,vec2(0.0));
				border_fog=border_fog+.5*curve;
				border_fog=border_fog>1.5?0:border_fog;
				border_fog=clamp((border_fog-(1.-BORDER_FOG*.1))*1./(BORDER_FOG*.1),0.0,1.0);//
				
		
					#endif
				
				//height
				//border_fog*=clamp(fragpos.y/300.,0.,1
				
				
				border_fog=clamp(border_fog,0.,1.);
				
				;//= textureLod(colortex0,texcoord.xy*.35,0).rgb;//texcoord
				
				//fog_color = 0.*textureLod(colortex4,vec2(texcoord.x*0.01+.1,(texcoord.y)*0.05),0).rgb + fog_color;
				
				vec3 fog_color = .001*textureLod(colortex15,texcoord.xy,0).rgb;//texcoord
	
	
	
	
	
	
	
	
	
	//border_fog=0;//debug
	color.rgb = mix(color.rgb,fog_color ,border_fog);
	
	//color.rgb =
				#endif
}


  color *= vl.a;
  if (isEyeInWater == 1){
    vec3 fragpos = toScreenSpace(vec3(texcoord,z));
    color.rgb *= exp(-length(fragpos)*totEpsilon);
    vl.a *= dot(exp(-length(fragpos)*totEpsilon),vec3(0.2,0.7,0.1))*0.5+0.5;
  }
  if (isEyeInWater == 2){
    vec3 fragpos = toScreenSpace(vec3(texcoord-vec2(0.0)*texelSize*0.5,z));
    color.rgb *= exp(-length(fragpos)*vec3(0.2,0.7,4.0)*4.);
    color.rgb += vec3(4.0,0.5,0.1)*0.5;
    vl.a = 0.0;
  }
  else
    color += vl.rgb;
	
	
	
	
  gl_FragData[0].r = vl.a;
  gl_FragData[1].rgb = clamp(color,6.11*1e-5,65000.0);


}







#else




#define BORDER_FOG 3 //[0 1 2 3 4 5 6 7 8 9 10] // amount of render distance in tenths to use for border fog . it's a fade out effect


flat varying vec3 zMults;
uniform sampler2D depthtex0;
uniform sampler2D colortex7;
uniform sampler2D colortex3;
uniform sampler2D colortex2;
uniform sampler2D colortex0;
uniform sampler2D colortex15;//sky background
uniform sampler2D noisetex;

uniform float frameTimeCounter;
uniform int frameCounter;
uniform float far;
uniform float near;
uniform int isEyeInWater;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferProjectionInverse;
uniform vec2 texelSize;
//uniform vec3 waterfogcolor;
uniform vec3 cameraPosition;
#include "lib/waterOptions.glsl"
#include "/lib/res_params.glsl"

#define clamp01(x) clamp(x, 0.0, 1.0)
#define fsign(x) (clamp01(x * 1e35) * 2.0 - 1.0)
float ld(float depth) {
    return 1.0 / (zMults.y - depth * zMults.z);		// (-depth * (far - near)) = (2.0 * near)/ld - far - near
}
#define diagonal3(m) vec3((m)[0].x, (m)[1].y, m[2].z)
#define  projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)
vec3 toScreenSpace(vec3 p) {
	vec4 iProjDiag = vec4(gbufferProjectionInverse[0].x, gbufferProjectionInverse[1].y, gbufferProjectionInverse[2].zw);
    vec3 p3 = p * 2. - 1.;
    vec4 fragposition = iProjDiag * p3.xyzz + gbufferProjectionInverse[3];
    return fragposition.xyz / fragposition.w;
}
vec4 BilateralUpscale(sampler2D tex, sampler2D depth,vec2 coord,float frDepth){
  coord = coord;
  vec4 vl = vec4(0.0);
  float sum = 0.0;
  mat3x3 weights;
  const ivec2 scaling = ivec2(1.0/VL_RENDER_RESOLUTION);
  ivec2 posD = ivec2(coord*VL_RENDER_RESOLUTION)*scaling;
  ivec2 posVl = ivec2(coord*VL_RENDER_RESOLUTION);
  float dz = zMults.x;
  ivec2 pos = (ivec2(gl_FragCoord.xy+frameCounter) % 2 )*2;
	//pos = ivec2(1,-1);

  ivec2 tcDepth =  posD + ivec2(-2,-2) * scaling + pos * scaling;
  float dsample = ld(texelFetch2D(depth,tcDepth,0).r);
  float w = abs(dsample-frDepth) < dz ? 1.0 : 1e-5;
  vl += texelFetch2D(tex,posVl+ivec2(-2)+pos,0)*w;
  sum += w;

	tcDepth =  posD + ivec2(-2,0) * scaling + pos * scaling;
  dsample = ld(texelFetch2D(depth,tcDepth,0).r);
  w = abs(dsample-frDepth) < dz ? 1.0 : 1e-5;
  vl += texelFetch2D(tex,posVl+ivec2(-2,0)+pos,0)*w;
  sum += w;

	tcDepth =  posD + ivec2(0) + pos * scaling;
  dsample = ld(texelFetch2D(depth,tcDepth,0).r);
  w = abs(dsample-frDepth) < dz ? 1.0 : 1e-5;
  vl += texelFetch2D(tex,posVl+ivec2(0)+pos,0)*w;
  sum += w;

	tcDepth =  posD + ivec2(0,-2) * scaling + pos * scaling;
  dsample = ld(texelFetch2D(depth,tcDepth,0).r);
  w = abs(dsample-frDepth) < dz ? 1.0 : 1e-5;
  vl += texelFetch2D(tex,posVl+ivec2(0,-2)+pos,0)*w;
  sum += w;

  return vl/sum;
}
float getWaterHeightmap(vec2 posxz, float iswater) {
	vec2 pos = posxz;
  float moving = clamp(iswater*2.-1.0,0.0,1.0);
	vec2 movement = vec2(-0.005*frameTimeCounter*moving,0.0);
	float caustic = 0.0;
	float weightSum = 0.0;
	float radiance =  2.39996;
	mat2 rotationMatrix  = mat2(vec2(cos(radiance),  -sin(radiance)),  vec2(sin(radiance),  cos(radiance)));
	for (int i = 1; i < 3; i++){
		vec2 displ = texture2D(noisetex, pos/32.0/1.74/1.74 + movement).bb*2.0-1.0;
    float wave = texture2D(noisetex, (pos*vec2(3., 1.0)/128. + movement + displ/128.0)*exp(i*1.0)).b;
		caustic += wave*exp(-i*1.0);
		weightSum += exp(-i*1.0);
		pos = rotationMatrix * pos;
	}
	return caustic / weightSum;
}
void main() {
  vec2 texcoord = gl_FragCoord.xy*texelSize;
  /* DRAWBUFFERS:73 */
  //3x3 bilateral upscale from half resolution
  float z = texture2D(depthtex0,texcoord).x;
  float frDepth = ld(z);
  vec4 vl = BilateralUpscale(colortex0,depthtex0,gl_FragCoord.xy,frDepth);



  vec4 transparencies = texture2D(colortex2,texcoord);
  vec4 trpData = texture2D(colortex7,texcoord);
  bool iswater = trpData.a > 0.99;
  vec2 refractedCoord = texcoord;

  if (iswater){
    vec3 fragpos = toScreenSpace(vec3(texcoord-vec2(0.0)*texelSize*0.5,z));
  	vec3 np3 = mat3(gbufferModelViewInverse) * fragpos + gbufferModelViewInverse[3].xyz + cameraPosition;
    float norm = getWaterHeightmap(np3.xz+np3.y, 1.0)-0.5;
    float displ = norm/(length(fragpos)/far)/2000. * (1.0 + isEyeInWater*2.0);
    refractedCoord += displ*RENDER_SCALE;

    if (texture2D(colortex7,refractedCoord).a < 0.99)
      refractedCoord = texcoord;

  }
  vec3 color = texture2D(colortex3,refractedCoord).rgb;

  

  
  	
  
  if (frDepth > 2.5/far || transparencies.a < 0.99)  // Discount fix for transparencies through hand
    color = color*(1.0-transparencies.a)+transparencies.rgb*10.;

  float dirtAmount = Dirt_Amount;
	vec3 waterEpsilon = vec3(Water_Absorb_R, Water_Absorb_G, Water_Absorb_B);
	vec3 dirtEpsilon = vec3(Dirt_Absorb_R, Dirt_Absorb_G, Dirt_Absorb_B);
	vec3 totEpsilon = dirtEpsilon*dirtAmount + waterEpsilon;

 
 //if (iswater)
{
#if BORDER_FOG == 0
				#else
				float border_fog  = textureLod(depthtex0,texcoord.xy,0).x;
				// from gl_FragCoord.z to world measurements
				border_fog = 2.0 * near  * far / (far + near - (2.0 * border_fog - 1.0) * (far - near));
				
				border_fog=clamp(2*border_fog/far,0.0,2.0);
				float curve = distance(texcoord.xy-.5,vec2(0.0));
				border_fog=border_fog+.5*curve;
				//border_fog=border_fog>1.5?0.:border_fog;
				
				
				
				border_fog=clamp((border_fog-(1.-BORDER_FOG*.1))/(BORDER_FOG*.1),0.0,1.0);//
				
				//debug
				//border_fog*= border_fog;//debug
				
				vec3 fog_color = .001*textureLod(colortex15,texcoord.xy,0).rgb;//texcoord
	

	color.rgb = mix(color.rgb,fog_color ,border_fog);
				#endif
}


  color *= vl.a;
  if (isEyeInWater == 1){
    vec3 fragpos = toScreenSpace(vec3(texcoord,z));
    color.rgb *= exp(-length(fragpos)*totEpsilon);
    vl.a *= dot(exp(-length(fragpos)*totEpsilon),vec3(0.2,0.7,0.1))*0.5+0.5;
  }
  if (isEyeInWater == 2){
    vec3 fragpos = toScreenSpace(vec3(texcoord-vec2(0.0)*texelSize*0.5,z));
    color.rgb *= exp(-length(fragpos)*vec3(0.2,0.7,4.0)*4.);
    color.rgb += vec3(4.0,0.5,0.1)*0.5;
    vl.a = 0.0;
  }
  else
    color += vl.rgb;
	
	
	
	
  gl_FragData[0].r = vl.a;
  gl_FragData[1].rgb = clamp(color,6.11*1e-5,65000.0);


}


#endif